/***************************************************************************
 *                                                                         *
 *   LinuxSampler - modular, streaming capable sampler                     *
 *                                                                         *
 *   Copyright (C) 2003, 2004 by Benno Senoner and Christian Schoenebeck   *
 *   Copyright (C) 2005 - 2025 Christian Schoenebeck                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 ***************************************************************************/

// All application global declarations that HAVE to be exposed to the C++
// API are defined here.

#ifndef __LS_GLOBAL_H__
#define __LS_GLOBAL_H__

// workaround for a bug with older versions of mingw, which would prevent
// portable format specifiers like PRId64 from being defined
#ifdef __MINGW32__
# define __STDC_FORMAT_MACROS 1
#endif

// C++ header <string> before any C headers intentionally here, due to
// format specifiers bug occurring with older versions of mingw (see above)
#include <string>
#include <stdlib.h>
#include <stdint.h>
#include <stdio.h>
#include <inttypes.h>

typedef std::string String;

#if defined(WIN32)
#include <windows.h>

// modern MinGW has usleep
#if (__MINGW32_MAJOR_VERSION < 3 ||                                     \
     (__MINGW32_MAJOR_VERSION == 3 && __MINGW32_MINOR_VERSION < 15)) && \
    !defined(__MINGW64) && !defined(__MINGW64_VERSION_MAJOR)
#define usleep(a) Sleep(a/1000)
#endif

#define sleep(a) Sleep(a*1000)
typedef unsigned int uint;
// FIXME: define proper functions which do proper alignement under Win32
#define alignedMalloc(a,b) malloc(b)
#define alignedFree(a) free(a)
#else
// needed for usleep under POSIX
#include <stdio.h>
// for uint
#include <sys/types.h>
#endif

#ifdef __GNUC__
#define DEPRECATED_API __attribute__ ((deprecated))
#else
#define DEPRECATED_API
#endif

// whether compiler is C++11 standard compliant
#if defined(__cplusplus) && __cplusplus >= 201103L
# define IS_CPP11 1
#endif

// C++ "override" keyword introduced with C++11 standard
#if IS_CPP11
# define OVERRIDE override
# define FINAL final
#else
# define OVERRIDE
# define FINAL
#endif

// So called 'dynamic exception specifiers' were deprecated in C++11 and
// removed without replacement in C++17. Instead of wiping them completely
// from the code base, they were replaced by using this macro, which in
// turn resolves to nothing for now.
//
// This preserves the chance that we might bring them back with very little
// work in case a replacement is re-introduced in a future version of the
// C++ standard.
#ifndef LS_THROWS
# define LS_THROWS(...)
#endif

#endif // __LS_GLOBAL_H__
