#!/bin/sh
#
# Generates the LSCP parser's C++ source files (src/network/lscp.tab.cpp and
# src/network/lscp.tab.h) according to the LSCP (BNF) grammar definition
# given by src/network/lscp.y

SCRIPTS_DIR=`dirname $0`
NETWORK_SRC_DIR="$SCRIPTS_DIR/../src/network"

echo -n "Searching for a parser generator..."
BISON_BIN=NONE
BISON_CMD=NONE
if which "bison" > /dev/null; then
    BISON_BIN=`which bison`
    bison_version=`bison --version | head -n 1 | sed -e 's/[^0-9.]*\([-0-9.]\+\)$/\1/'`
    bison_version_major=`echo $bison_version | cut -d. -f1`
    bison_version_minor=`echo $bison_version | cut -d. -f2`
    if [ "$bison_version_major" -gt "2" ]; then
        # Keep backward compatibility to Bison 2, therefore silence
        # Bison 3 warnings about deprecated features.
        BISON_CMD="$BISON_BIN -Wno-deprecated"
    else
        BISON_CMD="$BISON_BIN"
    fi
else
    echo "Error: You need GNU Bison to generate the LSCP parser !"
    exit -1
fi
echo "OK ($BISON_BIN)"

echo "Generating LSCP parser..."
(
    cd $NETWORK_SRC_DIR
    $BISON_CMD -o lscp.tab.cpp --defines=lscp.tab.h lscp.y
)
echo "Done"

echo -n "Updating Documentation/lscp.xml..."
(cd $SCRIPTS_DIR && ./update_lscp_grammar.pl)
echo "Done"

echo -n "Generating src/network/lscp_shell_reference.cpp..."
(cd $SCRIPTS_DIR && ./generate_lscp_shell_reference.pl)
echo "Done"
